{********************************************
; File: QDAux.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT QDAUX;
INTERFACE
USES TYPES,QUICKDRAW;
CONST


{
    PicInfo - The following picture
    opcodes are for reference only!!
}

frameVerb = $00;
picNop = $00;
drawCharVerb = $00;
paintVerb = $01;
picClipRgn = $01;
drawTextVerb  = $01;
eraseVerb = $02;
picBkPat = $02;
drawCStrVerb = $02;
invertVerb = $03;
picTxFont = $03;
fillVerb = $04;
picTxFace = $04;
picTxMode = $05;
picSpExtra = $06;
picPnSize = $07;
picPnMode = $08;
picPnPat = $09;
picThePat = $0A;
picFillPat = $0A;  { Please use picThePat }
picOvSize = $0B;
picOrigin = $0C;
picTxSize = $0D;
picFGColor = $0E;
picBGColor = $0F;
picTxRatio = $10;
picVersion = $11;
picChExtra = $12;
picPnMask = $13;
picArcRot = $14;
picFontFlags = $15;
lineNoun = $20;
picLine = $20;
picLineFrom = $21;
picShortL = $22;
picShortLine = $22;
picShortLFrom = $23;
picLongText = $28;
picDHText = $29;
picDVText = $2A;
picDVDHText = $2B;
rectNoun = $30;
rRectNoun = $40;
ovalNoun = $50;
arcNoun = $60;
polyNoun = $70;
rgnNoun = $80;
mapNoun = $90;
picBitsRect = $90;
picBitsRgn = $91;
picPBitsRect = $98;
picPBitsRgn = $99;
picShortComment = $A0;
picLongComment = $A1;
picEnd = $FF;

{ SeedFill/CalcMask Masks }
resMode640PMask = $00;
resMode640DMask = $01;
resMode320Mask = $02;
destModeCopyMask = $0000;
destModeLeaveMask = $1000;
destModeOnesMask = $2000;
destModeClrToZeros = $2000;
destModeZerosMask = $3000;
destModeClrToOnes = $3000;

{ Error Codes }
badRectSize = $1211;
destModeError = $1212;

{ Other Constants }
fTextJust = $0008;

TYPE
QDIconRecordHndl = ^QDIconRecordPtr;
QDIconRecordPtr = ^QDIconRecord;
QDIconRecord = RECORD
    iconType : Integer;
    iconSize : Integer;
    iconHeight : Integer;
    iconWidth : Integer;
    iconImage : PACKED ARRAY[1..1] OF Byte;
    iconMask : PACKED ARRAY[1..1] OF Byte;
END;
PicHndl = ^PicPtr;
PicPtr = ^Picture;
Picture = RECORD
    picSCB : Integer;
    picFrame : Rect;
    pVersion : Integer; { Followed by picture opcodes  }
END;
LeakTablePtr = ^LeakTable;
LeakTable = RECORD
    leakCount : Integer;
    leakColors : ARRAY[1..16] OF Integer;
END;
PROCEDURE CalcMask ( srcLocInfoPtr:LocInfo; srcRect:Rect; dstLocInfoPtr:LocInfo; dstRect:Rect; resMode:Integer; aPatternPtr:PatternPtr; leakTblPtr:LeakTable)  ;
PROCEDURE ClosePicture   ;
PROCEDURE CopyPixels ( srcLocPtr:LocInfo; destLocPtr:LocInfo; srcRect:Rect; destRect:Rect; xferMode:Integer; makeRgn:RegionHndl)  ;
PROCEDURE DrawIcon ( iconPtr:QDIconRecord; displayMode:Integer; xPos:Integer; yPos:Integer)  ;
PROCEDURE DrawPicture ( picHandle:PicHndl; destRect:Rect)  ;
PROCEDURE KillPicture ( pichandle:PicHndl)  ;
FUNCTION OpenPicture ( picFrame:Rect) : PicHndl ;
PROCEDURE PicComment ( kind:Integer; dataSize:Integer; dataHandle:Handle)  ;
PROCEDURE QDAuxBootInit   ;
PROCEDURE QDAuxReset   ;
PROCEDURE QDAuxShutDown   ;
PROCEDURE QDAuxStartUp   ;
FUNCTION QDAuxStatus  : Boolean ;
FUNCTION QDAuxVersion  : Integer ;
PROCEDURE SeedFill ( srcLocInfoPtr:LocInfo; srcRect:Rect; dstLocInfoPtr:LocInfo; dstRect:Rect; seedH:Integer; seedV:Integer; resMode:Integer; aPatternPtr:PatternPtr; leakTblPtr:LeakTable)  ;
PROCEDURE SpecialRect ( rectPtr:Rect; frameColor:Integer; fillColor:Integer)  ;
PROCEDURE WaitCursor   ;
IMPLEMENTATION
END.
